<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\View\View;

class LoginController extends Controller
{
    public function showLoginForm(): View
    {
        return view('admin.login');
    }

    public function login(Request $request): RedirectResponse
    {
        $request->validate([
            'username' => 'required|string',
            'password' => 'required|string',
        ]);

        $username = config('services.admin.username');
        $password = config('services.admin.password');

        if ($request->input('username') !== $username || $request->input('password') !== $password) {
            return back()->withInput($request->only('username'))
                ->with('error', 'Invalid username or password');
        }

        $request->session()->put('admin_logged_in', true);
        $request->session()->put('admin_username', $username);

        return redirect()->route('admin.dashboard');
    }

    public function logout(Request $request): RedirectResponse
    {
        $request->session()->forget(['admin_logged_in', 'admin_username']);
        return redirect()->route('admin.login');
    }
}
