<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Login – {{ config('app.name') }}</title>
    <style>
        * { box-sizing: border-box; }
        body { margin: 0; min-height: 100vh; display: flex; align-items: center; justify-content: center; background: #1a1a1a; font-family: system-ui, sans-serif; }
        .login-container { width: 100%; max-width: 400px; padding: 2rem; background: #2b2b2b; border-radius: 12px; box-shadow: 0 8px 32px rgba(0,0,0,0.2); }
        .logo { text-align: center; margin-bottom: 2rem; }
        .logo h2 { color: #fff; font-size: 24px; font-weight: 500; margin: 0; }
        .form-label { color: #fff; font-size: 14px; margin-bottom: 8px; display: block; }
        .form-control { width: 100%; padding: 12px; background: #333; border: 1px solid #404040; border-radius: 6px; color: #fff; margin-bottom: 16px; font-size: 14px; }
        .form-control:focus { outline: none; border-color: #0066cc; }
        .btn-primary { width: 100%; padding: 12px; background: #0066cc; border: none; border-radius: 6px; color: #fff; font-size: 14px; font-weight: 500; cursor: pointer; }
        .btn-primary:hover { background: #0052a3; }
        .error-message { background: rgba(220,53,69,0.1); color: #ff6b6b; padding: 12px; border-radius: 6px; margin-bottom: 16px; text-align: center; font-size: 14px; }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="logo">
            <h2>Admin Panel</h2>
        </div>
        @if(session('error'))
            <div class="error-message">{{ session('error') }}</div>
        @endif
        <form method="POST" action="{{ route('admin.login') }}">
            @csrf
            <div>
                <label for="username" class="form-label">Username</label>
                <input type="text" id="username" name="username" class="form-control" value="{{ old('username') }}" required autocomplete="username" placeholder="Enter username">
            </div>
            <div>
                <label for="password" class="form-label">Password</label>
                <input type="password" id="password" name="password" class="form-control" required autocomplete="current-password" placeholder="Enter password">
            </div>
            <button type="submit" class="btn-primary">Login</button>
        </form>
    </div>
</body>
</html>
