# Enable PHP fileinfo extension (Windows)

Laravel needs the **fileinfo** extension. Enable it in PHP’s config.

---

## Steps

1. **Open the PHP folder**  
   Go to **C:\php** (or wherever you extracted PHP).

2. **Create or choose php.ini**
   - If you see **php.ini** → open it.
   - If you only see **php.ini-development** or **php.ini-production** → copy one of them and rename the copy to **php.ini**, then open **php.ini**.

3. **Enable fileinfo**
   - Press **Ctrl+F** and search for: **fileinfo**
   - You should find a line like:
     ```ini
     ;extension=fileinfo
     ```
   - Remove the semicolon so it becomes:
     ```ini
     extension=fileinfo
     ```
   - Save the file (Ctrl+S).

4. **Run Composer again**
   ```bash
   cd "C:\Users\PC\Desktop\google sc vet\backend"
   composer install --no-dev
   ```

If you get errors about other missing extensions (e.g. **openssl**, **mbstring**, **pdo_mysql**), enable them the same way in **php.ini**: find `;extension=openssl` and change to `extension=openssl`, etc., then save and run `composer install --no-dev` again.
