# Install Composer on Windows

Composer is needed to download Laravel’s dependencies. Follow these steps once.

---

## Option 1: Official installer (recommended)

1. **Download the installer**
   - Open: **https://getcomposer.org/Composer-Setup.exe**
   - Run **Composer-Setup.exe**

2. **In the installer**
   - It will look for PHP. If it says “PHP not found”:
     - Download PHP for Windows: https://windows.php.net/download/
     - Pick **VS16 x64 Thread Safe** (ZIP), extract to e.g. `C:\php`
     - In the Composer installer, point “PHP executable” to `C:\php\php.exe`
   - If you already have XAMPP, Laragon, or WAMP, choose that PHP (e.g. `C:\xampp\php\php.exe`).
   - Click **Next** and complete the install (leave “Add to PATH” checked).

3. **Close and reopen Command Prompt** so the PATH updates.

4. **Test**
   ```bash
   composer --version
   ```
   You should see something like `Composer version 2.x.x`.

5. **Then run (in your project)**
   ```bash
   cd "C:\Users\PC\Desktop\google sc vet\backend"
   composer install --no-dev
   ```

---

## Option 2: Install PHP + Composer with Chocolatey

If you use **Chocolatey** (https://chocolatey.org):

1. Open **Command Prompt as Administrator** and run:
   ```bash
   choco install php composer -y
   ```
2. Close and reopen Command Prompt, then:
   ```bash
   cd "C:\Users\PC\Desktop\google sc vet\backend"
   composer install --no-dev
   ```

---

## Option 3: Skip Composer on your PC – use Namecheap only

If you prefer not to install anything on your PC:

1. **Zip and upload** the **backend** folder as it is (without a **vendor** folder).
2. In Namecheap cPanel, open **Terminal** (or **SSH**).
3. Go to the backend folder and run:
   ```bash
   cd public_html/backend
   composer install --no-dev
   php artisan key:generate
   php artisan migrate --force
   chmod -R 755 storage bootstrap/cache
   ```

**Note:** Many shared hosts don’t have Composer or Terminal. If yours doesn’t, you’ll need Option 1 or 2 on your PC so you can run `composer install` there, then zip and upload the **backend** folder (including **vendor**).
