<?php

namespace App\Services;

use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;

class TelegramService
{
    public function send(string $text): bool
    {
        $token = config('services.telegram.token');
        $chatId = config('services.telegram.chat_id');
        if (!$token || !$chatId) {
            return false;
        }
        try {
            $response = Http::asForm()->post("https://api.telegram.org/bot{$token}/sendMessage", [
                'chat_id' => $chatId,
                'text' => $text,
                'parse_mode' => 'HTML',
            ]);
            if (!$response->successful()) {
                Log::warning('Telegram send failed', ['body' => $response->body()]);
            }
            return $response->successful();
        } catch (\Throwable $e) {
            Log::error('Telegram error: ' . $e->getMessage());
            return false;
        }
    }

    public static function now(): string
    {
        return now()->utc()->format('d/m/Y h:i:sa');
    }
}
