<?php

use Illuminate\Http\Request;

// Avoid 404 for browser favicon request (no favicon file in root)
$uri = $_SERVER['REQUEST_URI'] ?? '';
if (preg_match('#^/favicon\.ico(\?.*)?$#', $uri)) {
    header('HTTP/1.1 204 No Content');
    exit;
}

define('LARAVEL_START', microtime(true));

require __DIR__ . '/backend/vendor/autoload.php';

$app = require_once __DIR__ . '/backend/bootstrap/app.php';

$kernel = $app->make(Illuminate\Contracts\Http\Kernel::class);

$response = $kernel->handle(
    $request = Request::capture()
)->send();

$kernel->terminate($request, $response);
